﻿var publish = {
    context: $(".v-publish"),
    datatable: null,
    initializeDataTable: function () {
        publish.datatable = $(".h-publishedItemsTable", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetPublishedItems", "Project", "Reporting"),
            columns: [
                { "Name": "PortalName", "Title": resources.PortalName, "Data": "PortalName" },
                { "Name": "ItemType", "Title": resources.ItemType, "Data": "ItemTypeEnum", "Type": "enum", "EnumType": "ReportPublishItemType" },
                { "Name": "ItemName", "Title": resources.ItemName, "Data": "ItemName" },
                { "Name": "SubscriberType", "Title": resources.SubscriberType, "Data": "SubscriberTypeEnum", "Type": "enum", "EnumType": "SubscriberType" },
                { "Name": "SubscriberName", "Title": resources.SubscriberName, "Data": "SubscriberName" }
            ],
            localizableTexts: { "Search": resources.SearchProjectPublish },
            stateKey: "Publish",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            toolBarClick: function (event, data) {
                var action = data.action;

                if (action == "delete") {
                    var rows = data.rows;

                    var items = _.map(rows, function (row) {
                        var item = {};
                        item.PortalId = row.PortalId;
                        item.ItemType = row.ItemType;
                        item.ItemTypeEnum = row.ItemTypeEnum;
                        item.ItemId = row.ItemId;
                        item.SubscriberType = row.SubscriberType;
                        item.SubscriberTypeEnum = row.SubscriberTypeEnum;
                        item.SubscriberId = row.SubscriberId;
                        return item;
                    });

                    publish.deletePublishedItems(items);
                }
            },
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuClick: function (event, data) {
                var action = data.action;

                switch (action) {
                    case "delete":
                        publish.deletePublishedItems([data.row]);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(".h-publishMenu").on("click", "li.h-publish", function () {
            var itemType = $(this).attr("data-type");
            modalDialog.showWindow(a4.getAction("PublishItem", "Project", "Reporting", { itemType: itemType }), 600, 700, { afterClose: function () { publish.refreshContent(); } });
        });
    },
    deletePublishedItems: function (rows) {
        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeletePublishedItems", "Project", "Reporting"), { items: rows },
                function (result) {
                    publish.refreshContent();
                });
        }, 250, 500, true, { "count": rows.length });
    },
    refreshContent: function () {
        publish.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (publish.context.length > 0) {
        publish.bindEvents();
        publish.initializeDataTable();
    }
});